package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.HeartRateReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface HeartRateReadingRepository extends JpaRepository<HeartRateReading, Long>{
	
    @Query("select a from HeartRateReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<HeartRateReading>  getHeartRateReadingsForUser(@Param ("userprofileid") Long userprofileid);
    
    
    @Query("select a from HeartRateReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<HeartRateReading>  getDashBoardHeartRateReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);


}
